// Custom Character Generator
// Author: Darrel Taylor
// Date: NOV 6, 2005
//
// Please don't RIP
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

var defaultColor   = ["#FFFFFF","#000000","#DDFFFF"]

/* ----- Pixel --- defines a single square ----------------------------------------------- */
function Pixel(parent,container, Row, Col, ID, size, click) {
    this.parent = parent;
    this.state = 0;
    this.laststatus = 0;
    this.size = size;
    this.ID = ID;
    this.container = container;
    this.obj = null;
    this.row = Row;
    this.col = Col;

    this.stateColor = function(){
                                if (this.state == undefined) return parent.lcdbgcolor;
                                if (this.state == 0) return parent.OFFcolor;
                                if (this.state == 1) return parent.ONcolor;
                            };
    this.create = function() {
                        this.obj = this.container.insertCell(Col);
                        this.obj.bgColor = this.stateColor();
                        this.obj.ID = this.ID;
                        this.obj.height = this.size;
                        this.obj.width = this.size;
                        this.obj.row = this.row;
                        this.obj.col = this.col;
                        if (click != undefined) {
                            this.obj.onclick = function () {FlipCell(this)};
                        }
                    };
    this.setPixel = function(state) {
                            this.state = state;
                            this.obj.bgColor = this.stateColor();
                        };
    this.setSize = function(size) {
                            this.size = size;
                            chkObj(this);
                            if (this.obj != undefined) {this.obj.height = size; this.obj.width = size;}
                            else  alert('Pixel: Obj Not Fount ('+this.ID+')');
                   };
    this.create();
}

function ToHEX (V) {
    var HEXchars = ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"]
    var Lnib = (V & 15);
    var Hnib = ((V/16) & 15);
    var S = "$" + HEXchars[Hnib] + HEXchars[Lnib];
    return S;
}

/* ----- Char --- defines a single character --------------------------------------------- */
function Char(parent,container,ID,Cnum, size,click) {
    this.parent = parent;
    this.size = size;
    this.ID = ID;
    this.container = container;
    this.obj = null;
    this.Cnum = Cnum;
    this.text = " ";
    this.pixels = new Array(8);
    for(var i=0;i<8;i++){
        this.pixels[i] = new Array(5);
    }
    this.create = function () {
        this.container.innerHTML = '<table id="'+this.ID+'" border="0" cellspacing="1" cellpadding="0"></table>';
        this.obj = document.getElementById(this.ID);
        if ((this.obj == null) || (this.obj == undefined)) alert('Char: char table not found! - '+this.ID);
        for(var CRow=0;CRow<8;CRow++){
            var TheRow = this.obj.insertRow(CRow);
            for(var CCol=0;CCol<5;CCol++){
                PID = this.ID+'R'+CRow+'C'+CCol;
                this.pixels[CRow][CCol] = new Pixel(this.parent,TheRow, CRow, CCol, PID, size, click);
            }
        }

    };
    this.setSize = function (size) {
        this.size = size;
        for(var Row=0;Row<8;Row++){
            for(var Col=0;Col<5;Col++){
                this.pixels[Row][Col].setSize(this.size);
            }
        }
    };

    this.refresh = function () {
        this.setText(this.text);
    };

    this.dataStr = '';
    this.isBlank = true;

    this.setData = function () {
        this.isBlank = true;
        if (parent.DataType == "DEC") {
            this.dataStr = '  LCDOUT  254,'+ (8+this.Cnum)*8 +',';
        } else {
            this.dataStr = '  LCDOUT  $FE,'+ ToHEX((8+this.Cnum)*8) +',';
        }
        for(var Row=0;Row<8;Row++){
            var RowValue = 0;
            for(var Col=0;Col<5;Col++){
                var color = this.pixels[Row][Col].state;
                RowValue = RowValue * 2;   // << 1
                if (color == 1) {
                    this.isBlank = false;
                    RowValue = RowValue + 1;
                }
            }
            if (parent.DataType == "DEC") {
                this.dataStr += RowValue;
            } else {
                this.dataStr += ToHEX(RowValue);
            }
            if (Row < 7) {
                this.dataStr = this.dataStr +',';
            }
        }

    };
    this.getData = function () {
        if (this.dataStr == '') this.setData();
        return (this.dataStr);

    };

    this.create();
}




function CustomChars (ID) {
    this.ID = ID;
    this.obj = null;  // refers to the <table> generated by write()
    this.psize = 5;
    this.lcdbgcolor = defaultColor[0];
    this.ONcolor = defaultColor[1];
    this.OFFcolor = defaultColor[2];
    this.Chars = new Array(8);
    this.Headers = new Array(8);
    this.CurrentChar = 0;
    this.EntryChar = null;
    this.EntryCharContainer = null;
    this.ResultsDiv = null;
    this.DataType = "DEC";

    this.write = function () {
        document.write('<table id="'+this.ID+'" border="1" cellspacing="0" cellpadding="0">');
        document.write('</table>');

    };
    //---------------------------------
    this.create = function () {
        if (this.obj == null) {
            var O = document.getElementById(this.ID);
            if (O != undefined) {
                this.obj = O;
            } else {
                alert(this.ID+'  Not Found in CustomChars ');
            }
        }
        var TheRow = this.obj.insertRow(0);
        for(var C=0;C<8;C++){                       // the Char cells
            var TheCell = TheRow.insertCell(C);
            TheCell.align = "center";
            TheCell.onclick = function () {SelectCC(this)};
            var CID = 'CC'+C;
            TheCell.ID = CID;
            this.Chars[C] = new Char(this,TheCell,CID,C,this.psize);
        }
        TheCell = TheRow.insertCell(8);

        TheCell.valign = "bottom";
        var t = ''
        t += '<table border="0" width="90%" cellspacing="0" cellpadding="0"><tr><td rowspan="2" align="left" width="90%">';

        t += '&nbsp;&nbsp;&nbsp;<button  onclick="ClearAll();return false;">Clear ALL</button>';
        if (navigator.vendor!="Firefox")
            t += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button onClick="CopyClip();">Copy to Clipboard</BUTTON>';

        t += '</td><td colspan="2" align="center" nowrap><b>Numbers are</b></td></tr><tr><td nowrap>';
        t += '<font size="-1"><input id="fp1" type="radio" name="Numbers" value="DEC" checked onclick="DECclicked()"><label for="fp1">DEC</label></font></td><td nowrap>';
        t += '<font size="-1"><input id="fp2" type="radio" name="Numbers" value="HEX" onclick="HEXclicked()"><label for="fp2">HEX</label></font></td></tr></table>';

        TheCell.innerHTML = t;

        TheRow = this.obj.insertRow(0);              // Header Cells
        for(var C=0;C<8;C++){
            TheCell = TheRow.insertCell(C);
            this.Headers[C] = TheCell;
            TheCell.ID = 'HH'+C;
            TheCell.align = "center";
            TheCell.innerHTML = '<b>'+C+'</b>';
            TheCell.onclick = function () {SelectCC(this)};
        }
        TheCell = TheRow.insertCell(8);
        TheCell.align = "right";
        TheCell.innerHTML = '<b>Custom Character Generator &nbsp; &nbsp; &nbsp;  by Darrel Taylor &nbsp; </b>';

/*        TheRow = this.obj.insertRow(2);              // Second Charset ???

        TheCell = TheRow.insertCell(0);
        TheCell.colSpan = 8;
        TheCell = TheRow.insertCell(1);
        TheCell.innerHTML = "<p>Something Here</p>";
*/

        TheRow = this.obj.insertRow(2);              // Entry Char
        TheCell = TheRow.insertCell(0);
        TheCell.colSpan = 8;
        TheCell.align = "center";
        TheCell.bgColor = "#CCCCFF";
        this.EntryCharContainer = TheCell;
        this.EntryChar = new Char(this,TheCell,"Entry",8,40,"FlipCell()")

        TheCell = TheRow.insertCell(1);             // Results Pane
        TheCell.rowSpan = 2;
        TheCell.vAlign = 'top';
        TheCell.innerHTML = '<div id="Results">&nbsp;results</div>';

        SelectCC(this.Chars[this.CurrentChar]);
    };

}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

function ShowObj(obj) {
    var Blank = '                                   ';
    var S = '';
    var C = 0;
    for (i in obj) {
        var objStr = i + ' = '+obj[i];
        S += objStr + Blank.substring(objStr.length,Blank.length);
        C ++;
        if (C == 4) {S += '\n';C=0};
    }
    alert('ShowObj: ['+obj+']\n\n'+S);
}

function HEXclicked () {
    if (Cust.DataType != "HEX") {
        Cust.DataType = "HEX";
        for (C=0;C<8;C++) {
            Cust.Chars[C].setData();
        }
        ShowResults();
    }
}

function DECclicked () {
    if (Cust.DataType != "DEC") {
        Cust.DataType = "DEC";
        for (C=0;C<8;C++) {
            Cust.Chars[C].setData();
        }
        ShowResults();
    }
}

// ------------------------------------------------------------------
function FlipCell(obj) {
    CopyToCell = Cust.Chars[Cust.CurrentChar].pixels[obj.row][obj.col];
    var color = Cust.EntryChar.pixels[obj.row][obj.col].state;
    if (color == 1) {color = 0} else {color = 1};
    Cust.EntryChar.pixels[obj.row][obj.col].setPixel(color);
    CopyToCell.setPixel(color);
    Cust.Chars[Cust.CurrentChar].setData();
ShowResults();
}


function ClearChar(Cnum){
    for(var Row=0;Row<8;Row++){
        for(var Col=0;Col<5;Col++){
            Cust.Chars[Cnum].pixels[Row][Col].setPixel(0);
        }
    }
    Cust.Chars[Cnum].setData();
}

function ClearAll() {
    for(var CH=0;CH<8;CH++){
        ClearChar(CH);
    }
    aChar = Cust.Chars[0];
    SelectCC(aChar);
    return false;
}

    //---------------------------------
function SelectCC (obj){
        var CharNum = obj.ID.substring(2,3);
        if (obj.ID.charAt(0) == 'H') {
            obj = Cust.Chars[CharNum];
        }
        for(var CC=0;CC<8;CC++) {
            TheCell = Cust.Chars[CC]
            TopCell = Cust.Headers[CC];
            if (Cust.Chars[CC].ID == obj.ID) {
                Cust.CurrentChar = CharNum;
                TheCell.obj.bgColor = '#CCCCFF';
                TopCell.bgColor = '#CCCCFF';
                }
            else {
                TheCell.obj.bgColor = '#FFFFFF';
                TopCell.bgColor = '#FFFFFF';
            }
        }
        CopyChar(Cust.CurrentChar);
        ShowResults();
    };

function CopyChar(CharNum) {
    for(var Row=0;Row<8;Row++){
        for(var Col=0;Col<5;Col++){
            CopyFromCell = Cust.Chars[CharNum].pixels[Row][Col];
            CopyToCell   = Cust.EntryChar.pixels[Row][Col];
            CopyToCell.setPixel(CopyFromCell.state);
        }
    }
}

function ShowResults() {
var Res = '<pre>';
    for(var CH=0;CH<8;CH++){
        var CharIsBlank = 1;
        if (CH == Cust.CurrentChar) {
            Res = Res + '<FONT style="BACKGROUND-COLOR: yellow">';
        }
        if ((Cust.Chars[CH].isBlank == false) || (CH == Cust.CurrentChar)) {
            var RowText = Cust.Chars[CH].getData();
            if (Cust.DataType == "HEX") {
                var S = '                                                   \' Cust Char #'+CH;
            } else {
                var S = '                                           \' Cust Char #'+CH;
            }
            Res = Res + RowText + S.substring(RowText.length,80);

            if (CH == Cust.CurrentChar) {
                Res = Res + '</FONT>';
            }
            Res = Res + '  <br>'
        }
    }
    Res = Res + '</font>';
    if (Cust.ResultsDiv == null) {
        Cust.ResultsDiv = document.getElementById("Results");
        if (!Cust.ResultsDiv) alert('Results DIV - Not Found');
    }
    if (Cust.ResultsDiv) {
        Cust.ResultsDiv.innerHTML = Res;
    }
};

function CopyClip() {
var Res = '';
    for(var CH=0;CH<8;CH++){
        CharIsBlank = 1;
        if ((Cust.Chars[CH].isBlank == false) || (CH == Cust.CurrentChar)) {
            var RowText = Cust.Chars[CH].getData();
            if (Cust.DataType == "HEX") {
                var S = '                                                   \' Cust Char #'+CH;
            } else {
                var S = '                                           \' Cust Char #'+CH;
            }
            Res = Res + RowText + S.substring(RowText.length,80)+unescape("%0D%0A");// + S.fromCharCode(13, 10);
        }
    }
    HT = document.getElementById("holdtext")
    HT.innerText = Res;
    Copied = HT.createTextRange();
    Copied.execCommand("Copy");
};

var Old_onload = window.onload;

function CConload () {
    if (Old_onload) Old_onload();
    Cust.create();
};

function CCgen() {
    Cust = new CustomChars("CustC1");
    Cust.write();
    document.write('<TEXTAREA id="holdtext" STYLE="display:none;"><BR></TEXTAREA></FONT>');

    if (document.getElementById("holdtext") == undefined)
        window.onload = CConload
    else
        Cust.create();
};

